<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row mb-4">
                <div class="col-12">
                <?php if (isset($_SESSION['success_message'])) : ?>
                                <script>
                                    Swal.fire({
                                        icon: "success",
                                        title: "Éxito",
                                        text: "<?php echo $_SESSION['success_message']; ?>",
                                        timer: 1000,
                                        showConfirmButton: true
                                    });
                                </script>
                            <?php unset($_SESSION['success_message']); ?>
                            <?php endif; ?>
                            <?php if (isset($_SESSION['error_message'])) : ?>
                                <script>
                                    toastr.error("<?php echo $_SESSION['error_message']; ?>" );
                                </script>
                                <?php unset($_SESSION['error_message']); ?>
                            <?php endif; ?>
                            <?php if (isset($_SESSION['success_messagea'])) : ?>
                                <script>
                                    new Noty({
                                        type: "success",
                                        text: "<?php echo $_SESSION['success_messagea']; ?>",
                                        timeout: 1000
                                    }).show();
                                </script>
                                <?php unset($_SESSION['success_messagea']); ?>
                            <?php endif; ?>
                            <?php if (isset($_SESSION['success_messagea1'])) : ?>
                                <script>
                                    new Noty({
                                        type: "error",
                                        text: "<?php echo $_SESSION['success_messagea1']; ?>",
                                        timeout: 1000 
                                    }).show();
                                </script>
                                <?php unset($_SESSION['success_messagea1']); ?>
                            <?php endif; ?>
                            <?php if (isset($_SESSION['eliminado'])) : ?>
                                <script>
                                    Swal.fire({
                                        icon: "error",
                                        title: "Eliminado",
                                        text: "<?php echo $_SESSION['eliminado']; ?>",
                                        timer: 1000,
                                        showConfirmButton: true
                                    });
                                </script>
                            <?php unset($_SESSION['eliminado']); ?>
                            <?php endif; ?>
                    <div class="card shadow">
                        <div class="card-header bg-primary text-white d-flex align-items-center justify-content-between">
                            <h5 class="card-title mb-0 text-white">Monedas Disponibles</h5>
                            <button class="btn btn-light btn-sm" data-bs-toggle="modal" data-bs-target="#modalAgregarMoneda">
                                + Nueva Moneda
                            </button>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Código</th>
                                        <th>Nombre</th>
                                        <th>Simbolo</th>
                                        <th>Tasa de Cambio</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody id="tablaMonedas">
                                    <?php $monedas = MonedasData::getAll(); ?>
                                    <?php foreach($monedas as $mon) {?>
                                    <tr>
                                        <td><?= $mon->codigo; ?></td>
                                        <td><?= $mon->nombre; ?></td>
                                        <td><?= $mon->simbolo; ?></td>
                                        <td>
                                            <?= (intval($mon->tasa_cambio) == $mon->tasa_cambio) 
                                                ? intval($mon->tasa_cambio) 
                                                : number_format($mon->tasa_cambio, 2); ?>
                                        </td>
                                        <td>
            <div class="d-flex gap-2">
                <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#modalEditarMoneda" 
                    data-id="<?= $mon->id; ?>"
                    data-codigo="<?= $mon->codigo; ?>"
                    data-nombre="<?= $mon->nombre; ?>"
                    data-simbolo="<?= $mon->simbolo; ?>"
                    data-tasa="<?= $mon->tasa_cambio; ?>">
                    <i class="fas fa-edit"></i> Editar
                </button>
                <button class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#modalEliminarMoneda" 
                    data-id="<?= $mon->id; ?>"
                    data-nombre="<?= $mon->nombre; ?>">
                    <i class="fas fa-trash"></i> Eliminar
                </button>
            </div>
        </td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Agregar Moneda -->
<div class="modal fade" id="modalAgregarMoneda" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Agregar Moneda</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <form class="tablelist-form" autocomplete="off" method="POST" action="index.php?action=registro">
                <div class="modal-body">
                    <div class="mb-3">
                        <label>Código</label>
                        <input type="text" name="codigo" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Nombre</label>
                        <input type="text" name="nombre" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Simbolo</label>
                        <input type="text" name="simbolo" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label>Tasa de Cambio</label>
                        <input type="number" name="tasa_cambio" id="edit_tasa" class="form-control" required step="0.01">
                    </div>

                    <input type="hidden" value="54" name="actions">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Editar Moneda -->
<div class="modal fade" id="modalEditarMoneda" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Moneda</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <form class="tablelist-form" autocomplete="off" method="POST" action="index.php?action=registro">
                <div class="modal-body">
                    <input type="hidden" name="id" id="edit_id">
                    <div class="mb-3">
                        <label>Código</label>
                        <input type="text" name="codigo" id="edit_codigo" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Nombre</label>
                        <input type="text" name="nombre" id="edit_nombre" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Simbolo</label>
                        <input type="text" name="simbolo" id="edit_simbolo" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label>Ingresar Nuevo Valor de Cambio   </label>
                        <input type="number" name="tasa_cambio" id="edit_tasa" class="form-control" required step="0.01">
                    </div>

                    <input type="hidden" value="56" name="actions">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Actualizar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Eliminar Moneda -->
<div class="modal fade" id="modalEliminarMoneda" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirmar Eliminación</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <form method="POST" action="index.php?action=registro">
                <div class="modal-body">
                    <input type="hidden" name="id" id="delete_id">
                    <p>¿Está seguro que desea eliminar la moneda <strong id="delete_nombre"></strong>?</p>
                    <input type="hidden" value="57" name="actions">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-danger">Eliminar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Modal de edición
        const modalEditarMoneda = document.getElementById('modalEditarMoneda');
        if (modalEditarMoneda) {
            modalEditarMoneda.addEventListener('show.bs.modal', function(event) {
                const button = event.relatedTarget;
                const id = button.getAttribute('data-id');
                const codigo = button.getAttribute('data-codigo');
                const nombre = button.getAttribute('data-nombre');
                const simbolo = button.getAttribute('data-simbolo');
                const tasa = button.getAttribute('data-tasa');
                
                document.getElementById('edit_id').value = id;
                document.getElementById('edit_codigo').value = codigo;
                document.getElementById('edit_nombre').value = nombre;
                document.getElementById('edit_simbolo').value = simbolo;
                document.getElementById('edit_tasa').value = tasa;
            });
        }
        
        // Modal de eliminación
        const modalEliminarMoneda = document.getElementById('modalEliminarMoneda');
        if (modalEliminarMoneda) {
            modalEliminarMoneda.addEventListener('show.bs.modal', function(event) {
                const button = event.relatedTarget;
                const id = button.getAttribute('data-id');
                const nombre = button.getAttribute('data-nombre');
                
                document.getElementById('delete_id').value = id;
                document.getElementById('delete_nombre').textContent = nombre;
            });
        }
    });
</script>