<?php function formato_soles($monto) {
    $simbolo_moneda = "S/ ";
    $monto_formateado = number_format($monto, 2, '.', ',');
    $monto_formateado = $simbolo_moneda . $monto_formateado;
    return $monto_formateado;
} ?>
<div class="main-content"> 
    <div class="page-content">
        <div class="container-fluid"> 
            <!-- Tarjetas de Resumen -->
            <div class="row">
                <!-- Artículos -->
                <div class="col-xl-3 col-md-6">
                    <div class="card card-animate">
                        <div class="card-body">
                            <?php 
                            $articulos = count(ArticuloData::vercontenido());
                            $stock_bajo = ArticuloData::getLowStockCount();
                            ?>
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">Artículos</p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-success fs-14 mb-0">
                                        <i class="ri-arrow-right-up-line fs-13 align-middle"></i><?= $articulos;?>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-4">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-4">
                                        <span class="counter-value" data-target="<?= $articulos;?>"><?= $articulos;?></span>
                                    </h4>
                                    <a href="articulo" class="text-decoration-underline">Ver Artículos</a>
                                    <?php if($stock_bajo > 0): ?>
                                        <div class="mt-2">
                                            <span class="badge bg-warning"><?= $stock_bajo ?> con stock bajo</span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-success rounded fs-3">
                                        <i class="ri-box-3-line text-success"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Ventas del Día -->
                <div class="col-xl-3 col-md-6">
                    <div class="card card-animate">
                        <div class="card-body">
                            <?php 
                            $ventas_hoy = VentaData::getTodaySales();
                            $total_ventas = formato_soles($ventas_hoy->total ?? 0);
                            ?>
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">Ventas Hoy</p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-primary fs-14 mb-0">
                                        <i class="ri-shopping-cart-line fs-13 align-middle"></i><?= $ventas_hoy->count ?? 0 ?>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-4">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-4"><?= $total_ventas ?></h4>
                                    <a href="venta" class="text-decoration-underline">Ver Ventas</a>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-primary rounded fs-3">
                                        <i class="ri-money-dollar-circle-line text-primary"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Colaboradores -->
                <div class="col-xl-3 col-md-6">
                    <div class="card card-animate">
                        <div class="card-body">
                            <?php $colaboradores = count(ClienteData::vercontenido()); ?>
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">Colaboradores</p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-info fs-14 mb-0">
                                        <i class="ri-team-line fs-13 align-middle"></i><?= $colaboradores;?>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-4">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-4">
                                        <span class="counter-value" data-target="<?= $colaboradores;?>"><?= $colaboradores;?></span>
                                    </h4>
                                    <a href="cliente" class="text-decoration-underline">Ver Colaboradores</a>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-info rounded fs-3">
                                        <i class="ri-user-heart-fill text-info"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Administradores -->
                <div class="col-xl-3 col-md-6">
                    <div class="card card-animate">
                        <div class="card-body">
                            <?php $admin = count(UserData::vercontenido()); ?>
                            <div class="d-flex align-items-center">
                                <div class="flex-grow-1 overflow-hidden">
                                    <p class="text-uppercase fw-medium text-muted text-truncate mb-0">Administradores</p>
                                </div>
                                <div class="flex-shrink-0">
                                    <h5 class="text-warning fs-14 mb-0">
                                        <i class="ri-admin-fill fs-13 align-middle"></i><?= $admin; ?>
                                    </h5>
                                </div>
                            </div>
                            <div class="d-flex align-items-end justify-content-between mt-4">
                                <div>
                                    <h4 class="fs-22 fw-semibold ff-secondary mb-4">
                                        <span class="counter-value" data-target="<?= $admin; ?>"><?= $admin; ?></span>
                                    </h4>
                                    <a href="usuario" class="text-decoration-underline">Ver Administradores</a>
                                </div>
                                <div class="avatar-sm flex-shrink-0">
                                    <span class="avatar-title bg-soft-warning rounded fs-3">
                                        <i class="ri-shield-user-line text-warning"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Gráficos y Tablas -->
            <div class="row mt-4">
                <!-- Gráfico Principal -->
                <div class="col-xl-8">
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex align-items-center">
                                <h5 class="card-title mb-0 flex-grow-1">Análisis de Ventas y Compras</h5>
                                <div class="flex-shrink-0">
                                    <select id="chartType" class="form-select form-select-sm">
                                        <option value="bar">Barras</option>
                                        <option value="line">Líneas</option>
                                        <option value="area">Área</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div id="chart" style="min-height: 400px;"></div>
                        </div>
                    </div>
                </div>

                <!-- Últimas Ventas -->
                <div class="col-xl-4">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Últimas Ventas</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-borderless table-nowrap align-middle mb-0">
                                    <thead>
                                        <tr class="text-muted">
                                            <th scope="col">Cliente</th>
                                            <th scope="col">Total</th>
                                            <th scope="col">Fecha</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $ultimas_ventas = VentaData::getLastSales(5);
                                        foreach($ultimas_ventas as $venta): 
                                        ?>
                                        <tr>
                                            <td><?= $venta->cliente_nombre ?></td>
                                            <td><?= formato_soles($venta->total) ?></td>
                                            <td><?= date('d/m/Y', strtotime($venta->fecha)) ?></td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Productos con Stock Bajo -->
            <div class="row mt-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Productos con Stock Bajo</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-borderless table-nowrap align-middle mb-0">
                                    <thead>
                                        <tr class="text-muted">
                                            <th scope="col">Producto</th>
                                            <th scope="col">Stock Actual</th>
                                            <th scope="col">Stock Mínimo</th>
                                            <th scope="col">Almacén</th>
                                            <th scope="col">Estado</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $productos_bajo_stock = ArticuloData::getLowStockProducts();
                                        foreach($productos_bajo_stock as $producto): 
                                        ?>
                                        <tr>
                                            <td><?= $producto->nombre ?></td>
                                            <td><?= $producto->stock_actual ?></td>
                                            <td><?= $producto->stock_minimo ?></td>
                                            <td><?= $producto->almacen_nombre ?></td>
                                            <td>
                                                <span class="badge bg-warning">Stock Bajo</span>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.card {
    border: none;
    box-shadow: 0 0.75rem 1.5rem rgba(18,38,63,.03);
    margin-bottom: 24px;
}

.card-animate {
    transition: all .4s;
}

.card-animate:hover {
    transform: translateY(calc(-1.5rem / 5));
    box-shadow: 0 0.75rem 1.5rem rgba(18,38,63,.1);
}

.avatar-title {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 3rem;
    height: 3rem;
}

.badge {
    padding: 0.5em 0.75em;
    font-weight: 500;
}

.table-borderless td, .table-borderless th {
    border: 0;
}

.table-nowrap td, .table-nowrap th {
    white-space: nowrap;
}
</style>

<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<script>
<?php
$base = Database::getInstance();
$con = $base->getConnection();

// Consulta para obtener ventas y compras por mes
$query = "SELECT 
    MONTH(fecha) AS mes,
    SUM(CASE WHEN accion = 1 THEN cantidad ELSE 0 END) AS compras,
    SUM(CASE WHEN accion = 2 THEN cantidad ELSE 0 END) AS ventas
FROM proceso 
WHERE YEAR(fecha) = YEAR(CURDATE())
GROUP BY MONTH(fecha)
ORDER BY mes";

$result = mysqli_query($con, $query);

// Inicializar arrays con 12 meses
$data = array(
    'compra' => array_fill(1, 12, 0),
    'venta' => array_fill(1, 12, 0)
);

// Llenar los arrays con los datos reales
while ($row = mysqli_fetch_assoc($result)) {
    $data['compra'][$row['mes']] = $row['compras'];
    $data['venta'][$row['mes']] = $row['ventas'];
}
?>

var options = {
    chart: {
        type: 'bar',
        height: 400,
        toolbar: {
            show: false
        }
    },
    series: [{
        name: 'Ventas',
        data: <?= json_encode(array_values($data['venta'])) ?>
    }, {
        name: 'Compras',
        data: <?= json_encode(array_values($data['compra'])) ?>
    }],
    xaxis: {
        categories: <?= json_encode(array('Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic')) ?>,
        labels: {
            style: {
                colors: '#6c757d',
                fontSize: '12px'
            }
        }
    },
    yaxis: {
        title: {
            text: 'Cantidad',
            style: {
                color: '#6c757d',
                fontSize: '12px'
            }
        },
        labels: {
            style: {
                colors: '#6c757d',
                fontSize: '12px'
            }
        }
    },
    colors: ['#0abf30', '#f7b84b'],
    grid: {
        borderColor: '#f1f1f1',
    },
    legend: {
        position: 'top',
        horizontalAlign: 'right',
        offsetY: -20,
        markers: {
            width: 8,
            height: 8,
            radius: 6
        }
    },
    dataLabels: {
        enabled: false
    }
};

var chart = new ApexCharts(document.querySelector("#chart"), options);
chart.render();

// Evento para cambiar el tipo de gráfico
document.getElementById('chartType').addEventListener('change', function() {
    var chartType = this.value;
    
    // Destruir el gráfico actual
    chart.destroy();
    
    // Crear nuevas opciones según el tipo de gráfico
    var newOptions = {
        chart: {
            type: chartType,
            height: 400,
            toolbar: {
                show: false
            }
        },
        series: [{
            name: 'Ventas',
            data: <?= json_encode(array_values($data['venta'])) ?>
        }, {
            name: 'Compras',
            data: <?= json_encode(array_values($data['compra'])) ?>
        }],
        xaxis: {
            categories: <?= json_encode(array('Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic')) ?>,
            labels: {
                style: {
                    colors: '#6c757d',
                    fontSize: '12px'
                }
            }
        },
        yaxis: {
            title: {
                text: 'Cantidad',
                style: {
                    color: '#6c757d',
                    fontSize: '12px'
                }
            },
            labels: {
                style: {
                    colors: '#6c757d',
                    fontSize: '12px'
                }
            }
        },
        colors: ['#0abf30', '#f7b84b'],
        grid: {
            borderColor: '#f1f1f1',
        },
        legend: {
            position: 'top',
            horizontalAlign: 'right',
            offsetY: -20,
            markers: {
                width: 8,
                height: 8,
                radius: 6
            }
        }
    };

    // Agregar configuraciones específicas según el tipo de gráfico
    if (chartType === 'bar') {
        newOptions.plotOptions = {
            bar: {
                horizontal: false,
                columnWidth: '45%',
                endingShape: 'rounded'
            }
        };
        newOptions.dataLabels = { enabled: false };
    } else if (chartType === 'line') {
        newOptions.stroke = {
            width: [2, 2],
            curve: 'smooth'
        };
        newOptions.markers = {
            size: 4,
            hover: {
                size: 6
            }
        };
    } else if (chartType === 'area') {
        newOptions.stroke = {
            width: [2, 2],
            curve: 'smooth'
        };
        newOptions.fill = {
            type: 'gradient',
            gradient: {
                shadeIntensity: 1,
                opacityFrom: 0.7,
                opacityTo: 0.9,
                stops: [0, 90, 100]
            }
        };
    }

    // Crear nuevo gráfico con las opciones actualizadas
    chart = new ApexCharts(document.querySelector("#chart"), newOptions);
    chart.render();
});
</script>