<div class="main-content">
    <div class="page-content">
        <div class="container-fluid">
            <div class="row mb-4">
                <div class="col-12">
                <?php if (isset($_SESSION['success_message'])) : ?>
                                <script>
                                    Swal.fire({
                                        icon: "success",
                                        title: "Éxito",
                                        text: "<?php echo $_SESSION['success_message']; ?>",
                                        timer: 1000,
                                        showConfirmButton: true
                                    });
                                </script>
                            <?php unset($_SESSION['success_message']); ?>
                            <?php endif; ?>
                            <?php if (isset($_SESSION['error_message'])) : ?>
                                <script>
                                    toastr.error("<?php echo $_SESSION['error_message']; ?>" );
                                </script>
                                <?php unset($_SESSION['error_message']); ?>
                            <?php endif; ?>
                            <?php if (isset($_SESSION['success_messagea'])) : ?>
                                <script>
                                    new Noty({
                                        type: "success",
                                        text: "<?php echo $_SESSION['success_messagea']; ?>",
                                        timeout: 1000
                                    }).show();
                                </script>
                                <?php unset($_SESSION['success_messagea']); ?>
                            <?php endif; ?>
                            <?php if (isset($_SESSION['success_messagea1'])) : ?>
                                <script>
                                    new Noty({
                                        type: "error",
                                        text: "<?php echo $_SESSION['success_messagea1']; ?>",
                                        timeout: 1000 
                                    }).show();
                                </script>
                                <?php unset($_SESSION['success_messagea1']); ?>
                            <?php endif; ?>
                            <?php if (isset($_SESSION['eliminado'])) : ?>
                                <script>
                                    Swal.fire({
                                        icon: "error",
                                        title: "Eliminado",
                                        text: "<?php echo $_SESSION['eliminado']; ?>",
                                        timer: 1000,
                                        showConfirmButton: true
                                    });
                                </script>
                            <?php unset($_SESSION['eliminado']); ?>
                            <?php endif; ?>
                    <div class="card shadow">
                        <div class="card-header bg-primary text-white d-flex align-items-center justify-content-between">
                            <h5 class="card-title mb-0 text-white">Configuración</h5>
                            <button class="btn btn-light btn-sm" data-bs-toggle="modal" data-bs-target="#modalAgregarMoneda">
                                + Agregar Tasa O Valor
                            </button>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>Clave</th>
                                        <th>Valor</th>
                                        <th>Descripcion</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody id="tablaMonedas">
                                    <?php $configuracion = ConfiguracionValoresData::getAll(); ?>
                                    <?php foreach($configuracion as $config) {?>
                                    <tr>
                                        <td><?= $config->clave; ?></td>
                                        <td><?= $config->valor; ?></td>
                                        <td><?= $config->descripcion; ?></td>
                                        <td>
                                            <div class="d-flex gap-2">
                                                <button class="btn btn-sm btn-warning" 
                                                        data-bs-toggle="modal" 
                                                        data-bs-target="#modalEditarValor" 
                                                        data-id="<?= $config->id; ?>"
                                                        data-clave="<?= $config->clave; ?>"
                                                        data-valor="<?= $config->valor; ?>"
                                                        data-descripcion="<?= $config->descripcion; ?>">
                                                    <i class="ri-pencil-line"></i> Editar
                                                </button>
                                                <button class="btn btn-sm btn-danger" 
                                                        data-bs-toggle="modal" 
                                                        data-bs-target="#modalEliminarValor"
                                                        data-id="<?= $config->id; ?>"
                                                        data-clave="<?= $config->clave; ?>">
                                                    <i class="ri-delete-bin-line"></i> Eliminar
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Agregar Moneda -->
<div class="modal fade" id="modalAgregarMoneda" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Agregar Valor</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <form class="tablelist-form" autocomplete="off" method="POST" action="index.php?action=registro">
                <div class="modal-body">
                    <div class="mb-3">
                        <label>Clave</label>
                        <input type="text" name="clave" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Valor</label>
                        <input type="text" name="valor" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Descripcion</label>
                        <input type="text" name="descripcion" class="form-control">
                    </div>

                    <input type="hidden" value="51" name="actions">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Editar Valor -->
<div class="modal fade" id="modalEditarValor" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Editar Valor</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <form class="tablelist-form" autocomplete="off" method="POST" action="index.php?action=registro">
                <div class="modal-body">
                    <div class="mb-3">
                        <label>Clave</label>
                        <input type="text" id="editar_clave" name="clave" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Valor</label>
                        <input type="text" id="editar_valor" name="valor" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Descripcion</label>
                        <input type="text" id="editar_descripcion" name="descripcion" class="form-control">
                    </div>

                    <input type="hidden" id="editar_id" name="id" value="">
                    <input type="hidden" value="52" name="actions">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Actualizar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Eliminar Valor -->
<div class="modal fade" id="modalEliminarValor" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Eliminar Valor</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
            </div>
            <form class="tablelist-form" autocomplete="off" method="POST" action="index.php?action=registro">
                <div class="modal-body">
                    <p>¿Está seguro que desea eliminar el valor <strong id="eliminar_clave"></strong>?</p>
                    <p class="text-danger">Esta acción no se puede deshacer.</p>
                    
                    <input type="hidden" id="eliminar_id" name="id" value="">
                    <input type="hidden" value="53" name="actions">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-danger">Eliminar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Script para cargar datos en modales -->
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Modal de Edición
        const modalEditarValor = document.getElementById('modalEditarValor');
        if (modalEditarValor) {
            modalEditarValor.addEventListener('show.bs.modal', function(event) {
                const button = event.relatedTarget;
                const id = button.getAttribute('data-id');
                const clave = button.getAttribute('data-clave');
                const valor = button.getAttribute('data-valor');
                const descripcion = button.getAttribute('data-descripcion');
                
                document.getElementById('editar_id').value = id;
                document.getElementById('editar_clave').value = clave;
                document.getElementById('editar_valor').value = valor;
                document.getElementById('editar_descripcion').value = descripcion;
            });
        }
        
        // Modal de Eliminación
        const modalEliminarValor = document.getElementById('modalEliminarValor');
        if (modalEliminarValor) {
            modalEliminarValor.addEventListener('show.bs.modal', function(event) {
                const button = event.relatedTarget;
                const id = button.getAttribute('data-id');
                const clave = button.getAttribute('data-clave');
                
                document.getElementById('eliminar_id').value = id;
                document.getElementById('eliminar_clave').textContent = clave;
            });
        }
    });
</script>