<?php
class TransferenciaData {
    public static $tablename = "transferencia";
        public $id;
        public $codigo;
        public $descripcion;
        public $fecha;
        public $usuario;
        public $estado;
        public $count;
        public $total;
        public $responsables;
        public function registro(){
            $sql = "insert into ".self::$tablename." (codigo,descripcion,usuario,estado,fecha) ";
            $sql .= "value (\"$this->codigo\",\"$this->descripcion\",\"$this->usuario\",\"$this->estado\",NOW())";
            return Executor::doit($sql);
        }
        public function actualizar(){
            $sql = "update ".self::$tablename." set nombre=\"$this->nombre\", descripcion=\"$this->descripcion\" where id=$this->id";
            Executor::doit($sql);
        }
        public static function verid($id){
            $sql = "select c.*, CONCAT(COALESCE(u.nombre, ''), ' ', COALESCE(u.apellido, '')) AS responsables from ".self::$tablename." c JOIN usuario u ON u.id=c.usuario where c.id=$id";
            $query = Executor::doit($sql);
            return Model::one($query[0],new TransferenciaData());
        }
        public function eliminar(){
            $sql = "delete from ".self::$tablename." where id=$this->id";
            Executor::doit($sql);
        }
        public static function vercontenido(){
            $sql = "select * from ".self::$tablename;
            $query = Executor::doit($sql);
            return Model::many($query[0],new TransferenciaData());
        }
        public static function duplicidad($nombre){
        $sql = "select * from ".self::$tablename." where nombre=\"$nombre\"";
        $query = Executor::doit($sql);
        $array = array();
        $cnt = 0;
        while($r = $query[0]->fetch_array()){
            $array[$cnt] = new TransferenciaData();
            $array[$cnt]->nombre = $r['nombre'];
            $cnt++;
            }
            return $array;
        }
        public static function evitarladuplicidad($nombre, $id){
            $sql = "select * from ".self::$tablename." where nombre=\"$nombre\" AND id!=\"$id\"";
            $query = Executor::doit($sql);
            $result = $query[0]->fetch_array();
            if($result){
                return true;
            }else{
                return false;
            }
        }

        public static function ultimocodigo() {
            $sql = "SELECT codigo FROM transferencia ORDER BY id DESC LIMIT 1";
            $query = Executor::doit($sql);
            $result = Model::one($query[0], new TransferenciaData());
            
            return $result ? $result->codigo : null;
        }

        public static function vercontenidoPaginado($start, $length, $search = ''){
            $sql = "SELECT c.*,  CONCAT(COALESCE(u.nombre, ''), ' ', COALESCE(u.apellido, '')) AS responsables FROM ".self::$tablename;
            $sql .= " c JOIN usuario u ON u.id=c.usuario ";
            if ($search) {
                $sql .= " WHERE c.codigo LIKE '%$search%'";
            }
            $sql .= " LIMIT $start, $length";
            $query = Executor::doit($sql);
            return Model::many($query[0], new TransferenciaData());
        }
        public static function totalRegistro(){
            $sql = "select COUNT(*) as total from ".self::$tablename;
            $query = Executor::doit($sql);
            $result = Model::one($query[0], new TransferenciaData());
            return $result->total;
        }
        public static function totalRegistrosFiltrados($search){
            $sql = "select COUNT(*) as total from ".self::$tablename;
            if ($search) {
                $sql .= " WHERE codigo LIKE '%$search%'";
            }
            $query = Executor::doit($sql);
            $result = Model::one($query[0], new TransferenciaData());
            return $result->total;
        }
        public function eliminarHijos($id) {
    $id = intval($id); // Seguridad
    $sql = "DELETE FROM proceso WHERE transferencia = ?";
    Executor::doit($sql, [$id]);
}
public function tieneRelacionesActivas($id) {
    $sql = "
        SELECT TABLE_NAME, COLUMN_NAME
        FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE
        WHERE REFERENCED_TABLE_NAME = ?
        AND REFERENCED_COLUMN_NAME = 'id'
        AND CONSTRAINT_SCHEMA = DATABASE();
    ";
    $params = ['transferencia'];
    $query = Executor::doit($sql, $params);
    $relations = Model::many($query[0], new stdClass());

    foreach ($relations as $relation) {
        $table = $relation->TABLE_NAME;
        $column = $relation->COLUMN_NAME;
        $sql_check = "SELECT COUNT(*) as count FROM $table WHERE $column = ?";
        $params_check = [$id];
        $query_check = Executor::doit($sql_check, $params_check);
        $result = Model::one($query_check[0], new stdClass());
        if ($result->count > 0) {
            return true;
        }
    }
    return false;
}



    }
?>