<?php
class CompraData {
    public static $tablename = "compra";
        public $id;
        public $subtotal;
        public $descuento;
        public $igv;
        public $tipocompra;
        public $adelanto;
        public $pendiente;
        public $usuario;
        public $estado;
        public $fecha;
        public $count;
        public $total;
        public $sucursales;
        public $responsable;
        public $tipo_moneda;

        public function registro(){
            $sql = "insert into ".self::$tablename." (subtotal,descuento,igv,total,usuario,estado,fecha,tipo_moneda) ";
            $sql .= "value (\"$this->subtotal\",\"$this->descuento\",\"$this->igv\",\"$this->total\",\"$this->usuario\",1,NOW(),\"$this->tipo_moneda\")";
            return Executor::doit($sql);
        }
        
        public function actualizar(){
            $sql = "update ".self::$tablename." set nombre=\"$this->nombre\", contacto=\"$this->contacto\", direccion=\"$this->direccion\", telefono=\"$this->telefono\", email=\"$this->email\", cp=\"$this->cp\", estado=\"$this->estado\", rfc=\"$this->rfc\", limitecredito=\"$this->limitecredito\", observaciones=\"$this->observaciones\", diascredito=\"$this->diascredito\" where id=$this->id";
            Executor::doit($sql);
        }
        public static function verid($id){
            $sql = "select c.*, CONCAT(u.nombre, ', ', u.apellido) as responsable from ".self::$tablename." c JOIN usuario u ON u.id=c.usuario where c.id=$id";
            $query = Executor::doit($sql);
            return Model::one($query[0],new CompraData());
        }
        public function eliminar(){
            $sql = "delete from ".self::$tablename." where id=$this->id";
            Executor::doit($sql);
        }
        public static function vercontenido(){
            $sql = "select * from ".self::$tablename;
            $query = Executor::doit($sql);
            return Model::many($query[0],new CompraData());
        }

        public static function duplicidad($nombre){
        $sql = "select * from ".self::$tablename." where nombre=\"$nombre\"";
        $query = Executor::doit($sql);
        $array = array();
        $cnt = 0;
        while($r = $query[0]->fetch_array()){
            $array[$cnt] = new CompraData();
            $array[$cnt]->nombre = $r['nombre'];
            $cnt++;
            }
            return $array;
        }
        public static function evitarladuplicidad($nombre, $id){
            $sql = "select * from ".self::$tablename." where nombre=\"$nombre\" AND id!=\"$id\"";
            $query = Executor::doit($sql);
            $result = $query[0]->fetch_array();
            if($result){ 
                return true;
            }else{
                return false;
            }
        }
        public static function vercontenidoPaginado($start, $length, $search = ''){
            $sql = "SELECT c.*, CONCAT(u.nombre, ', ', u.apellido) as responsable  FROM ".self::$tablename;
            $sql .= " c JOIN usuario u ON u.id=c.usuario ";
            if ($search) {
                $sql .= " WHERE c.descuento LIKE '%$search%'";
            }
            $sql .= " ORDER BY c.id DESC";
            $sql .= " LIMIT $start, $length";
            $query = Executor::doit($sql);
            return Model::many($query[0], new CompraData());
        }
        public static function totalRegistro(){
            $sql = "select COUNT(*) as total from ".self::$tablename;
            $query = Executor::doit($sql);
            $result = Model::one($query[0], new CompraData());
            return $result->total;
        }
        public static function totalRegistrosFiltrados($search){
            $sql = "select COUNT(*) as total from ".self::$tablename;
            if ($search) {
                $sql .= " WHERE descuento LIKE '%$search%'";
            }
            $query = Executor::doit($sql);
            $result = Model::one($query[0], new CompraData());
            return $result->total;
        }
        public $simbolo; 
         
        public static function vercontenido_reporte($fecha_inicio = null, $fecha_fin = null){
            $sql = "SELECT co.*, md.simbolo, CONCAT(u.nombre, ', ', u.apellido) as responsable 
                    FROM ".self::$tablename." co 
                    JOIN usuario u ON u.id=co.usuario
                    LEFT JOIN monedas md ON md.codigo = co.tipo_moneda";
            
            // Añadir condiciones de fecha si están presentes
            if ($fecha_inicio && $fecha_fin) {
                $sql .= " WHERE co.fecha BETWEEN '$fecha_inicio' AND '$fecha_fin'";
            } elseif ($fecha_inicio) {
                $sql .= " WHERE co.fecha >= '$fecha_inicio'";
            } elseif ($fecha_fin) {
                $sql .= " WHERE co.fecha <= '$fecha_fin'";
            }
            $sql .= " ORDER BY co.fecha desc"; 
            $query = Executor::doit($sql);
            return Model::many($query[0], new CompraData());
        }

        //nuevo codigo:
        public $tipo_operacion;
        public static function vercontenido_reporte_nuevo($fecha_inicio = null, $fecha_fin = null, $producto_id = null){
            // Construir las condiciones WHERE para cada subconsulta
            $where_compra = "";
            $where_venta = "";
            
            // Condiciones de fecha
            if ($fecha_inicio && $fecha_fin) {
                $where_compra = " WHERE co.fecha BETWEEN '$fecha_inicio' AND '$fecha_fin'";
                $where_venta = " WHERE v.fecha BETWEEN '$fecha_inicio' AND '$fecha_fin'";
            } elseif ($fecha_inicio) {
                $where_compra = " WHERE co.fecha >= '$fecha_inicio'";
                $where_venta = " WHERE v.fecha >= '$fecha_inicio'";
            } elseif ($fecha_fin) {
                $where_compra = " WHERE co.fecha <= '$fecha_fin'";
                $where_venta = " WHERE v.fecha <= '$fecha_fin'";
            }
            
            // Agregar condición de producto si se especifica
            if ($producto_id) {
                // Para compras
                $join_producto_compra = " JOIN proceso p ON p.compra = co.id";
                $condicion_producto_compra = ($where_compra ? " AND" : " WHERE") . " p.articulo = $producto_id";
                
                // Para ventas
                $join_producto_venta = " JOIN proceso vd ON vd.venta = v.id";
                $condicion_producto_venta = ($where_venta ? " AND" : " WHERE") . " vd.articulo = $producto_id";
                
                $where_compra .= $condicion_producto_compra;
                $where_venta .= $condicion_producto_venta;
            } else {
                $join_producto_compra = "";
                $join_producto_venta = "";
            }
            
            // Consulta unificada que combina compras y ventas
            $sql = "
            (
                SELECT 
                    co.id,
                    co.fecha,
                    co.subtotal,
                    co.descuento,
                    co.igv,
                    co.total,
                    md.simbolo,
                    CONCAT(u.nombre, ', ', u.apellido) as responsable,
                    'COMPRA' as tipo_operacion
                FROM ".self::$tablename." co
                JOIN usuario u ON u.id = co.usuario
                LEFT JOIN monedas md ON md.codigo = co.tipo_moneda
                $join_producto_compra
                $where_compra
                " . ($producto_id ? " GROUP BY co.id" : "") . "
            )
            UNION ALL
            (
                SELECT 
                    v.id,
                    v.fecha,
                    v.subtotal,
                    v.descuento,
                    v.igv,
                    v.total,
                    md.simbolo,
                    CONCAT(u.nombre, ', ', u.apellido) as responsable,
                    'VENTA' as tipo_operacion
                FROM venta v
                JOIN usuario u ON u.id = v.usuario
                LEFT JOIN monedas md ON md.codigo = v.tipo_moneda
                $join_producto_venta
                $where_venta
                " . ($producto_id ? " GROUP BY v.id" : "") . "
            )
            ORDER BY fecha DESC";
            
            $query = Executor::doit($sql);
            return Model::many($query[0], new CompraData());
        }
        
    }
?>