<?php
require_once 'tcpdf/tcpdf.php';

$desde = $_GET['desde'] ?? '';
$hasta = $_GET['hasta'] ?? '';
$mostrarTodo = isset($_GET['mostrar_todo']) ? true : false;

if ($mostrarTodo) {
    $clientes = ClienteData::getAllClientes();
} else {
    $clientes = ClienteData::reporte1($desde, $hasta, 'cliente');
}

// Crear PDF
class MYPDF extends TCPDF {
    public function Header() {
        // Logo opcional
        if (file_exists('logo.png')) {
            $this->Image('logo.png', 10, 10, 20);
        }

        $this->SetFont('helvetica', 'B', 14);
        $this->Cell(0, 10, 'SIS - VENTAS', 0, 1, 'C');
        $this->SetFont('helvetica', '', 11);
        $this->Cell(0, 5, 'Reporte de Clientes', 0, 1, 'C');
        $this->Ln(5);
    }

    public function Footer() {
        $this->SetY(-15);
        $this->SetFont('helvetica', 'I', 8);
        $this->Cell(0, 10, 'Página '.$this->getAliasNumPage().' de '.$this->getAliasNbPages(), 0, 0, 'C');
    }
}

$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf->SetCreator('Sistema');
$pdf->SetAuthor('Tu Sistema');
$pdf->SetTitle('Reporte de Clientes');
$pdf->SetSubject('Reporte por Fechas');

$pdf->SetMargins(15, 35, 15);
$pdf->SetHeaderMargin(10);
$pdf->SetFooterMargin(15);
$pdf->SetAutoPageBreak(TRUE, 20);
$pdf->SetFont('helvetica', '', 10);
$pdf->AddPage();

// Título dinámico
$titulo = 'REPORTE DE CLIENTES';
if ($mostrarTodo) {
    $titulo .= ' - TODOS LOS REGISTROS';
} elseif ($desde && $hasta) {
    $titulo .= ' DEL ' . date('d/m/Y', strtotime($desde)) . ' AL ' . date('d/m/Y', strtotime($hasta));
}

$pdf->Ln(2);
$pdf->SetFont('helvetica', 'B', 12);
$pdf->SetFillColor(255, 255, 255);
$pdf->Cell(0, 10, $titulo, 0, 1, 'C', true);
$pdf->Ln(4);

// Encabezado de tabla
$pdf->SetFont('helvetica', 'B', 10);
$pdf->SetFillColor(100, 149, 237); // azul
$pdf->SetTextColor(255);
$header = ['Cliente', 'Teléfono', 'Email', 'Estado', 'Fecha'];
$w = [55, 30, 55, 20, 25];
for ($i = 0; $i < count($header); $i++) {
    $pdf->Cell($w[$i], 7, $header[$i], 1, 0, 'C', 1);
}
$pdf->Ln();

// Filas
$pdf->SetFont('helvetica', '', 9);
$pdf->SetTextColor(0);
$fill = false;
$pdf->SetFillColor(240, 248, 255); // color fila alterna

foreach ($clientes as $cliente) {
    $pdf->Cell($w[0], 6, $cliente->nombre, 'LR', 0, 'L', $fill);
    $pdf->Cell($w[1], 6, $cliente->telefono, 'LR', 0, 'C', $fill);
    $pdf->Cell($w[2], 6, $cliente->email, 'LR', 0, 'L', $fill);
    $estado = ($cliente->estado == 1) ? 'Activo' : 'Inactivo';
    $pdf->Cell($w[3], 6, $estado, 'LR', 0, 'C', $fill);
    $pdf->Cell($w[4], 6, date('d/m/Y', strtotime($cliente->fecha)), 'LR', 0, 'C', $fill);
    $pdf->Ln();
    $fill = !$fill;
}

// Línea final
$pdf->Cell(array_sum($w), 0, '', 'T');

// Total
$pdf->Ln(10);
$pdf->SetFont('helvetica', 'B', 10);
$pdf->Cell(0, 6, 'Total de Clientes: ' . count($clientes), 0, 1, 'R');

// Salida
$pdf->Output('reporte_clientes.pdf', 'I');
