<?php
// generar_pdf_Shtock.php
require_once 'tcpdf/tcpdf.php';

// Obtener parámetros
$tipo = isset($_GET['tipo']) ? $_GET['tipo'] : 'general';
$fecha_inicio = isset($_GET['start']) ? $_GET['start'] : null;
$fecha_fin = isset($_GET['end']) ? $_GET['end'] : null;

// Crear instancia de TCPDF con orientación horizontal
$pdf = new TCPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// Configurar información del documento
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Sistema de Inventario');
$pdf->SetTitle('Reporte de Stock');
$pdf->SetSubject('Reporte de Stock');
$pdf->SetKeywords('TCPDF, PDF, reporte, stock, inventario');

// Configurar márgenes
$pdf->SetMargins(10, 15, 10);
$pdf->SetHeaderMargin(5);
$pdf->SetFooterMargin(10);

// Configurar salto de página automático
$pdf->SetAutoPageBreak(TRUE, 15);

// Configurar fuente
$pdf->SetFont('helvetica', '', 8);

// Agregar página
$pdf->AddPage();

// Título del reporte
$titulo = 'REPORTE DE STOCK';
if ($tipo === 'filtrado' && ($fecha_inicio || $fecha_fin)) {
    $titulo .= ' (FILTRADO)';
    if ($fecha_inicio && $fecha_fin) {
        $titulo .= "\nPeríodo: " . date('d/m/Y', strtotime($fecha_inicio)) . ' al ' . date('d/m/Y', strtotime($fecha_fin));
    } elseif ($fecha_inicio) {
        $titulo .= "\nDesde: " . date('d/m/Y', strtotime($fecha_inicio));
    } elseif ($fecha_fin) {
        $titulo .= "\nHasta: " . date('d/m/Y', strtotime($fecha_fin));
    }
}

$pdf->SetFont('helvetica', 'B', 14);
$pdf->Cell(0, 10, $titulo, 0, 1, 'C');
$pdf->Ln(5);

// Fecha de generación
$pdf->SetFont('helvetica', '', 9);
$pdf->Cell(0, 5, 'Generado el: ' . date('d/m/Y'), 0, 0, 'R');
$pdf->Ln(5);

// Obtener datos según el tipo
if ($tipo === 'filtrado') {
    $operaciones = CompraData::vercontenido_reporte_nuevo($fecha_inicio, $fecha_fin);
} else {
    $operaciones = CompraData::vercontenido_reporte_nuevo();
}

if (empty($operaciones)) {
    $pdf->SetFont('helvetica', 'I', 12);
    $pdf->Cell(0, 10, 'No se encontraron datos para mostrar', 0, 1, 'C');
} else {
    // Función para dibujar encabezados
    function dibujarEncabezados($pdf, $col_widths) {
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->SetFillColor(52, 58, 64); // Color gris oscuro
        $pdf->SetTextColor(255, 255, 255); // Texto blanco
        
        $pdf->Cell($col_widths['fecha'], 10, 'Fecha', 1, 0, 'C', true);
        $pdf->Cell($col_widths['tipo'], 10, 'Tipo', 1, 0, 'C', true);
        $pdf->Cell($col_widths['articulo'], 10, 'Artículos', 1, 0, 'C', true);
        $pdf->Cell($col_widths['cantidad'], 10, 'Cantidad', 1, 0, 'C', true);
        $pdf->Cell($col_widths['saldo'], 10, 'Saldo', 1, 0, 'C', true);
        $pdf->Cell($col_widths['stock'], 10, 'Stock', 1, 0, 'C', true);
        $pdf->Cell($col_widths['destino'], 10, 'Destino', 1, 1, 'C', true);
        
        $pdf->SetTextColor(0, 0, 0);
    }
    
    // Definir anchos de columnas (solo hasta destino)
    $col_widths = array(
        'fecha' => 30,
        'tipo' => 25,
        'articulo' => 70,
        'cantidad' => 35,
        'saldo' => 35,
        'stock' => 35,
        'destino' => 47
    );
    
    // Encabezados iniciales
    dibujarEncabezados($pdf, $col_widths);
    
    $contador_operaciones = 0;
    
    foreach ($operaciones as $operacion) {
        $id_operacion = $operacion->id;
        $tipo_operacion = $operacion->tipo_operacion;
        $detalles = ProcesoData::vercontenidos_nuevo($id_operacion, $tipo_operacion);
        $num_articulos = count($detalles);
        
        // Contador para alternar colores
        $contador_operaciones++;
        
        // Color de fondo alternado por operación
        $fill_color = ($contador_operaciones % 2 == 0) ? array(248, 249, 250) : array(255, 255, 255);
        
        if ($num_articulos > 0) {
            foreach ($detalles as $index => $detalle) {
                // Verificar si necesitamos una nueva página
                if ($pdf->GetY() > 180) {
                    $pdf->AddPage();
                    dibujarEncabezados($pdf, $col_widths);
                }
                
                $pdf->SetFont('helvetica', '', 7);
                $cantidad_final = $detalle->cantidad / $detalle->cantidad_unidad;
                
                // Calcular saldo y stock
                $saldo_anterior = ProcesoData::obtenerSaldoAnteriorPorAlmacen_nuevo(
                    $detalle->articulo, 
                    $detalle->almacen, 
                    $operacion->fecha,
                    $tipo_operacion,
                    $id_operacion
                );
                
                $stock_actual = ProcesoData::calcularStockDespuesOperacion(
                    $saldo_anterior, 
                    $cantidad_final, 
                    $tipo_operacion
                );
                
                // Configurar color de fondo
                $pdf->SetFillColor($fill_color[0], $fill_color[1], $fill_color[2]);
                
                $row_height = 8;
                
                // Fecha (combinada para todos los artículos de la operación)
                if ($index == 0) {
                    // Guardar posición actual
                    $current_y = $pdf->GetY();
                    $current_x = $pdf->GetX();
                    
                    // Calcular altura total necesaria para la operación
                    $total_height = $num_articulos * $row_height;
                    
                    // Dibujar celda combinada para fecha
                    $pdf->MultiCell($col_widths['fecha'], $total_height, date('d/m/Y', strtotime($operacion->fecha)), 1, 'C', true, 0, '', '', true, 0, false, true, $total_height, 'M');
                    
                    // Dibujar celda combinada para tipo
                    $tipo_color = ($tipo_operacion === 'COMPRA') ? array(40, 167, 69) : array(220, 53, 69);
                    $pdf->SetTextColor($tipo_color[0], $tipo_color[1], $tipo_color[2]);
                    $pdf->SetFont('helvetica', 'B', 7);
                    $pdf->MultiCell($col_widths['tipo'], $total_height, $tipo_operacion, 1, 'C', true, 0, '', '', true, 0, false, true, $total_height, 'M');
                    $pdf->SetTextColor(0, 0, 0);
                    $pdf->SetFont('helvetica', '', 7);
                    
                    // Volver a la posición original para continuar con las otras columnas
                    $pdf->SetXY($current_x + $col_widths['fecha'] + $col_widths['tipo'], $current_y);
                } else {
                    // Para las filas siguientes, saltar las columnas de fecha y tipo
                    $pdf->SetX($pdf->GetX() + $col_widths['fecha'] + $col_widths['tipo']);
                }
                
                // Datos del artículo
                $pdf->Cell($col_widths['articulo'], $row_height, substr($detalle->articulos, 0, 40), 1, 0, 'L', true);
                $pdf->Cell($col_widths['cantidad'], $row_height, number_format($cantidad_final) . ' ' . substr($detalle->unidades, 0, 10), 1, 0, 'C', true);
                $pdf->Cell($col_widths['saldo'], $row_height, number_format($saldo_anterior) . ' ' . substr($detalle->unidades, 0, 10), 1, 0, 'C', true);
                
                // Stock (en rojo si es negativo)
                if ($stock_actual < 0) {
                    $pdf->SetTextColor(220, 53, 69);
                    $pdf->SetFont('helvetica', 'B', 7);
                }
                $pdf->Cell($col_widths['stock'], $row_height, number_format($stock_actual) . ' ' . substr($detalle->unidades, 0, 10), 1, 0, 'C', true);
                if ($stock_actual < 0) {
                    $pdf->SetTextColor(0, 0, 0);
                    $pdf->SetFont('helvetica', '', 7);
                }
                
                $pdf->Cell($col_widths['destino'], $row_height, substr($detalle->almacenes, 0, 25), 1, 1, 'C', true);
                
                // Si no es el último artículo de la operación, ajustar posición
                if ($index < $num_articulos - 1) {
                    $pdf->SetXY(10, $pdf->GetY());
                }
            }
            
            // Línea separadora entre operaciones
            $pdf->SetDrawColor(200, 200, 200);
            $pdf->Line(10, $pdf->GetY(), 287, $pdf->GetY());
            $pdf->SetDrawColor(0, 0, 0);
            $pdf->Ln(0);
            
        } else {
            // Operación sin artículos
            $pdf->SetFont('helvetica', '', 7);
            $pdf->SetFillColor($fill_color[0], $fill_color[1], $fill_color[2]);
            
            $pdf->Cell($col_widths['fecha'], 8, date('d/m/Y', strtotime($operacion->fecha)), 1, 0, 'C', true);
            
            $tipo_color = ($tipo_operacion === 'COMPRA') ? array(40, 167, 69) : array(220, 53, 69);
            $pdf->SetTextColor($tipo_color[0], $tipo_color[1], $tipo_color[2]);
            $pdf->SetFont('helvetica', 'B', 7);
            $pdf->Cell($col_widths['tipo'], 8, $tipo_operacion, 1, 0, 'C', true);
            $pdf->SetTextColor(0, 0, 0);
            $pdf->SetFont('helvetica', '', 7);
            
            $pdf->Cell($col_widths['articulo'], 8, 'Sin artículos', 1, 0, 'C', true);
            $pdf->Cell($col_widths['cantidad'], 8, '-', 1, 0, 'C', true);
            $pdf->Cell($col_widths['saldo'], 8, '-', 1, 0, 'C', true);
            $pdf->Cell($col_widths['stock'], 8, '-', 1, 0, 'C', true);
            $pdf->Cell($col_widths['destino'], 8, '-', 1, 1, 'C', true);
        }
    }
    
    // Agregar resumen al final
    
    
    
    if ($tipo === 'filtrado' && ($fecha_inicio || $fecha_fin)) {
        $periodo_texto = '';
        if ($fecha_inicio && $fecha_fin) {
            $periodo_texto = 'Del ' . date('d/m/Y', strtotime($fecha_inicio)) . ' al ' . date('d/m/Y', strtotime($fecha_fin));
        } elseif ($fecha_inicio) {
            $periodo_texto = 'Desde el ' . date('d/m/Y', strtotime($fecha_inicio));
        } elseif ($fecha_fin) {
            $periodo_texto = 'Hasta el ' . date('d/m/Y', strtotime($fecha_fin));
        }
        $pdf->Cell(0, 6, 'Período filtrado: ' . $periodo_texto, 0, 1, 'L');
    }
}

// Configurar nombre del archivo
$filename = 'reporte_stock_' . date('Y-m-d_H-i-s');
if ($tipo === 'filtrado') {
    $filename .= '_filtrado';
}
$filename .= '.pdf';

// Generar PDF
$pdf->Output($filename, 'I');
?>